/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.shedaniel.clothconfig2.forge.ClothConfigInitializer;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.Expandable;
import me.shedaniel.clothconfig2.forge.api.LazyResettable;
import me.shedaniel.clothconfig2.forge.api.ReferenceBuildingConfigScreen;
import me.shedaniel.clothconfig2.forge.api.ReferenceProvider;
import me.shedaniel.clothconfig2.forge.api.ScissorsHandler;
import me.shedaniel.clothconfig2.forge.api.ScrollingContainer;
import me.shedaniel.clothconfig2.forge.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.forge.gui.ClothConfigScreen;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

public class GlobalizedClothConfigScreen
extends AbstractConfigScreen
implements ReferenceBuildingConfigScreen,
Expandable {
    public ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private Widget cancelButton;
    private Widget exitButton;
    private final LinkedHashMap<ITextComponent, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final ScrollingContainer sideScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(4, 4, GlobalizedClothConfigScreen.this.getSideSliderPosition() - 14 - 4, GlobalizedClothConfigScreen.this.field_230709_l_ - 8);
        }

        @Override
        public int getMaxScrollHeight() {
            int i = 0;
            for (Reference reference : GlobalizedClothConfigScreen.this.references) {
                if (i != 0) {
                    i = (int)((float)i + 3.0f * reference.getScale());
                }
                float f = i;
                GlobalizedClothConfigScreen.this.field_230712_o_.getClass();
                i = (int)(f + 9.0f * reference.getScale());
            }
            return i;
        }
    };
    private Reference lastHoveredReference = null;
    private final ScrollingContainer sideSlider = new ScrollingContainer(){
        private Rectangle empty = new Rectangle();

        @Override
        public Rectangle getBounds() {
            return this.empty;
        }

        @Override
        public int getMaxScrollHeight() {
            return 1;
        }
    };
    private final List<Reference> references = Lists.newArrayList();
    private final LazyResettable<Integer> sideExpandLimit = new LazyResettable<Integer>(() -> {
        int max = 0;
        for (Reference reference : this.references) {
            ITextComponent referenceText = reference.getText();
            int width = this.field_230712_o_.func_238414_a_((ITextProperties)new StringTextComponent(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ").func_230529_a_(referenceText));
            if (width <= max) continue;
            max = width;
        }
        return Math.min(max + 8, this.field_230708_k_ / 4);
    });
    private boolean requestingReferenceRebuilding = false;

    @ApiStatus.Internal
    public GlobalizedClothConfigScreen(Screen parent, ITextComponent title, Map<ITextComponent, List<Object>> entriesMap, ResourceLocation backgroundLocation) {
        super(parent, title, backgroundLocation);
        entriesMap.forEach((categoryName, list) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : list) {
                AbstractConfigListEntry entry = object instanceof Tuple ? (AbstractConfigListEntry)((Tuple)object).func_76340_b() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put((ITextComponent)categoryName, entries);
        });
        this.sideSlider.scrollTo(0.0, false);
    }

    @Override
    public void requestReferenceRebuilding() {
        this.requestingReferenceRebuilding = true;
    }

    @Override
    public Map<ITextComponent, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.sideExpandLimit.reset();
        this.references.clear();
        this.buildReferences();
        this.listWidget = new ClothConfigScreen.ListWidget(this, this.field_230706_i_, this.field_230708_k_ - 14, this.field_230709_l_, 30, this.field_230709_l_ - 32, this.getBackgroundLocation());
        this.field_230705_e_.add(this.listWidget);
        this.listWidget.setLeftPos(14);
        this.categorizedEntries.forEach((category, entries) -> {
            if (!this.listWidget.func_231039_at__().isEmpty()) {
                this.listWidget.func_231039_at__().add(new EmptyEntry(5));
            }
            this.listWidget.func_231039_at__().add(new EmptyEntry(4));
            this.listWidget.func_231039_at__().add(new CategoryTextEntry((ITextComponent)category, (ITextComponent)category.func_230532_e_().func_240699_a_(TextFormatting.BOLD)));
            this.listWidget.func_231039_at__().add(new EmptyEntry(4));
            this.listWidget.func_231039_at__().addAll(entries);
        });
        int buttonWidths = Math.min(200, (this.field_230708_k_ - 50 - 12) / 3);
        this.cancelButton = new Button(0, this.field_230709_l_ - 26, buttonWidths, 20, (ITextComponent)(this.isEdited() ? new TranslationTextComponent("text.cloth-config.cancel_discard") : new TranslationTextComponent("gui.cancel")), widget -> this.quit());
        this.func_230480_a_(this.cancelButton);
        this.exitButton = new Button(0, this.field_230709_l_ - 26, buttonWidths, 20, NarratorChatListener.field_216868_a, button -> this.saveAll(true)){

            public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List entries : GlobalizedClothConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.field_230693_o_ = GlobalizedClothConfigScreen.this.isEdited() && !hasErrors;
                this.func_238482_a_((ITextComponent)(hasErrors ? new TranslationTextComponent("text.cloth-config.error_cannot_save") : new TranslationTextComponent("text.cloth-config.save_and_done")));
                super.func_230430_a_(matrices, mouseX, mouseY, delta);
            }
        };
        this.func_230480_a_(this.exitButton);
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    private void buildReferences() {
        this.categorizedEntries.forEach((categoryText, entries) -> {
            this.references.add(new CategoryReference((ITextComponent)categoryText));
            for (AbstractConfigEntry entry : entries) {
                this.buildReferenceFor(entry, 1);
            }
        });
    }

    private void buildReferenceFor(AbstractConfigEntry<?> entry, int layer) {
        List<ReferenceProvider<?>> referencableEntries = entry.getReferenceProviderEntries();
        if (referencableEntries != null) {
            this.references.add(new ConfigEntryReference(entry, layer));
            for (ReferenceProvider<?> referencableEntry : referencableEntries) {
                this.buildReferenceFor(referencableEntry.provideReferenceEntry(), layer + 1);
            }
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.lastHoveredReference = null;
        if (this.requestingReferenceRebuilding) {
            this.references.clear();
            this.buildReferences();
            this.requestingReferenceRebuilding = false;
        }
        int sliderPosition = this.getSideSliderPosition();
        ScissorsHandler.INSTANCE.scissor(new Rectangle(sliderPosition, 0, this.field_230708_k_ - sliderPosition, this.field_230709_l_));
        if (this.isTransparentBackground()) {
            this.func_238468_a_(matrices, 14, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        } else {
            this.func_231165_f_(0);
            this.overlayBackground(matrices, new Rectangle(14, 0, this.field_230708_k_, this.field_230709_l_), 64, 64, 64, 255, 255);
        }
        this.listWidget.width = this.field_230708_k_ - sliderPosition;
        this.listWidget.setLeftPos(sliderPosition);
        this.listWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (AbstractConfigEntry child : this.listWidget.func_231039_at__()) {
            child.lateRender(matrices, mouseX, mouseY, delta);
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.field_230712_o_.func_238407_a_(matrices, this.field_230704_d_.func_241878_f(), (float)sliderPosition + (float)(this.field_230708_k_ - sliderPosition) / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2.0f, 12.0f, -1);
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.cancelButton.field_230690_l_ = sliderPosition + (this.field_230708_k_ - sliderPosition) / 2 - this.cancelButton.func_230998_h_() - 3;
        this.exitButton.field_230690_l_ = sliderPosition + (this.field_230708_k_ - sliderPosition) / 2 + 3;
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.sideSlider.updatePosition(delta);
        this.sideScroller.updatePosition(delta);
        if (this.isTransparentBackground()) {
            this.func_238468_a_(matrices, 0, 0, sliderPosition, this.field_230709_l_, -1240461296, -972025840);
            this.func_238468_a_(matrices, 0, 0, sliderPosition - 14, this.field_230709_l_, 0x68000000, 0x68000000);
        } else {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            this.field_230706_i_.func_110434_K().func_110577_a(this.getBackgroundLocation());
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_225582_a_((double)(sliderPosition - 14), (double)this.field_230709_l_, 0.0).func_225583_a_(0.0f, (float)this.field_230709_l_ / 32.0f).func_225586_a_(68, 68, 68, 255).func_181675_d();
            buffer.func_225582_a_((double)sliderPosition, (double)this.field_230709_l_, 0.0).func_225583_a_(0.4375f, (float)this.field_230709_l_ / 32.0f).func_225586_a_(68, 68, 68, 255).func_181675_d();
            buffer.func_225582_a_((double)sliderPosition, 0.0, 0.0).func_225583_a_(0.4375f, 0.0f).func_225586_a_(68, 68, 68, 255).func_181675_d();
            buffer.func_225582_a_((double)(sliderPosition - 14), 0.0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(68, 68, 68, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_225582_a_(0.0, (double)this.field_230709_l_, 0.0).func_225583_a_(0.0f, (float)(this.field_230709_l_ + (int)this.sideScroller.scrollAmount) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            buffer.func_225582_a_((double)(sliderPosition - 14), (double)this.field_230709_l_, 0.0).func_225583_a_((float)(sliderPosition - 14) / 32.0f, (float)(this.field_230709_l_ + (int)this.sideScroller.scrollAmount) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            buffer.func_225582_a_((double)(sliderPosition - 14), 0.0, 0.0).func_225583_a_((float)(sliderPosition - 14) / 32.0f, (float)((int)this.sideScroller.scrollAmount) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            buffer.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, (float)((int)this.sideScroller.scrollAmount) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int shadeColor = this.isTransparentBackground() ? 120 : 160;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix, (float)(sliderPosition + 4), 0.0f, 100.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buffer.func_227888_a_(matrix, (float)sliderPosition, 0.0f, 100.0f).func_225586_a_(0, 0, 0, shadeColor).func_181675_d();
        buffer.func_227888_a_(matrix, (float)sliderPosition, (float)this.field_230709_l_, 100.0f).func_225586_a_(0, 0, 0, shadeColor).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(sliderPosition + 4), (float)this.field_230709_l_, 100.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix, (float)(sliderPosition - 14), 0.0f, 100.0f).func_225586_a_(0, 0, 0, shadeColor /= 2).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(sliderPosition - 14 - 4), 0.0f, 100.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(sliderPosition - 14 - 4), (float)this.field_230709_l_, 100.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(sliderPosition - 14), (float)this.field_230709_l_, 100.0f).func_225586_a_(0, 0, 0, shadeColor).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        Rectangle slideArrowBounds = new Rectangle(sliderPosition - 14, 0, 14, this.field_230709_l_);
        RenderSystem.enableAlphaTest();
        IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        this.field_230712_o_.func_238426_c_(ITextComponent.func_244388_a((String)">").func_241878_f(), (float)(sliderPosition - 7) - (float)this.field_230712_o_.func_78256_a(">") / 2.0f, (float)(this.field_230709_l_ / 2), (slideArrowBounds.contains(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF) | MathHelper.func_76125_a((int)MathHelper.func_76143_f((double)((1.0 - this.sideSlider.scrollAmount) * 255.0)), (int)0, (int)255) << 24, false, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)immediate, false, 0, 0xF000F0);
        this.field_230712_o_.func_238426_c_(ITextComponent.func_244388_a((String)"<").func_241878_f(), (float)(sliderPosition - 7) - (float)this.field_230712_o_.func_78256_a("<") / 2.0f, (float)(this.field_230709_l_ / 2), (slideArrowBounds.contains(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF) | MathHelper.func_76125_a((int)MathHelper.func_76143_f((double)(this.sideSlider.scrollAmount * 255.0)), (int)0, (int)255) << 24, false, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)immediate, false, 0, 0xF000F0);
        immediate.func_228461_a_();
        Rectangle scrollerBounds = this.sideScroller.getBounds();
        if (!scrollerBounds.isEmpty()) {
            ScissorsHandler.INSTANCE.scissor(new Rectangle(0, 0, sliderPosition - 14, this.field_230709_l_));
            int scrollOffset = (int)((double)scrollerBounds.y - this.sideScroller.scrollAmount);
            for (Reference reference : this.references) {
                matrices.func_227860_a_();
                matrices.func_227862_a_(reference.getScale(), reference.getScale(), reference.getScale());
                IFormattableTextComponent text = new StringTextComponent(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ").func_230529_a_(reference.getText());
                if (this.lastHoveredReference == null) {
                    int n = scrollerBounds.x;
                    int n2 = (int)((float)scrollOffset - 4.0f * reference.getScale());
                    int n3 = (int)((float)this.field_230712_o_.func_238414_a_((ITextProperties)text) * reference.getScale());
                    this.field_230712_o_.getClass();
                    if (new Rectangle(n, n2, n3, (int)((float)(9 + 4) * reference.getScale())).contains(mouseX, mouseY)) {
                        this.lastHoveredReference = reference;
                    }
                }
                this.field_230712_o_.func_238422_b_(matrices, text.func_241878_f(), (float)scrollerBounds.x, (float)scrollOffset, this.lastHoveredReference == reference ? 16769544 : 0xFFFFFF);
                matrices.func_227865_b_();
                float f = scrollOffset;
                this.field_230712_o_.getClass();
                scrollOffset = (int)(f + (float)(9 + 3) * reference.getScale());
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.sideScroller.renderScrollBar();
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.field_230709_l_);
        if (button == 0 && slideBounds.contains(mouseX, mouseY) && this.lastHoveredReference != null) {
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.lastHoveredReference.go();
            return true;
        }
        Rectangle slideArrowBounds = new Rectangle(this.getSideSliderPosition() - 14, 0, 14, this.field_230709_l_);
        if (button == 0 && slideArrowBounds.contains(mouseX, mouseY)) {
            this.setExpanded(!this.isExpanded());
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    public boolean isExpanded() {
        return this.sideSlider.scrollTarget == 1.0;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.sideSlider.scrollTo(expanded ? 1.0 : 0.0, true, 2000L);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.field_230709_l_);
        if (slideBounds.contains(mouseX, mouseY)) {
            this.sideScroller.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    private int getSideSliderPosition() {
        return (int)(this.sideSlider.scrollAmount * (double)this.sideExpandLimit.get().intValue() + 14.0);
    }

    private class ConfigEntryReference
    implements Reference {
        private AbstractConfigEntry<?> entry;
        private int layer;

        public ConfigEntryReference(AbstractConfigEntry<?> entry, int layer) {
            this.entry = entry;
            this.layer = layer;
        }

        @Override
        public int getIndent() {
            return this.layer;
        }

        @Override
        public ITextComponent getText() {
            return this.entry.getFieldName();
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int[] i = new int[]{0};
            for (AbstractConfigEntry child : GlobalizedClothConfigScreen.this.listWidget.func_231039_at__()) {
                int i1 = i[0];
                if (this.goChild(i, null, child)) {
                    return;
                }
                i[0] = i1 + child.getItemHeight();
            }
        }

        private boolean goChild(int[] i, Integer expandedParent, AbstractConfigEntry<?> root) {
            boolean expanded;
            if (root == this.entry) {
                GlobalizedClothConfigScreen.this.listWidget.scrollTo(expandedParent == null ? (double)i[0] : (double)expandedParent.intValue(), true);
                return true;
            }
            int j = i[0];
            i[0] = i[0] + root.getInitialReferenceOffset();
            boolean bl = expanded = root instanceof Expandable && ((Expandable)((Object)root)).isExpanded();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(true);
            }
            List children = root.func_231039_at__();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(expanded);
            }
            for (IGuiEventListener child : children) {
                if (!(child instanceof ReferenceProvider)) continue;
                int i1 = i[0];
                if (this.goChild(i, expandedParent != null ? expandedParent : (root instanceof Expandable && !expanded ? Integer.valueOf(j) : null), ((ReferenceProvider)child).provideReferenceEntry())) {
                    return true;
                }
                i[0] = i1 + ((ReferenceProvider)child).provideReferenceEntry().getItemHeight();
            }
            return false;
        }
    }

    private class CategoryReference
    implements Reference {
        private ITextComponent category;

        public CategoryReference(ITextComponent category) {
            this.category = category;
        }

        @Override
        public ITextComponent getText() {
            return this.category;
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int i = 0;
            for (AbstractConfigEntry child : GlobalizedClothConfigScreen.this.listWidget.func_231039_at__()) {
                if (child instanceof CategoryTextEntry && ((CategoryTextEntry)child).category == this.category) {
                    GlobalizedClothConfigScreen.this.listWidget.scrollTo(i, true);
                    return;
                }
                i += child.getItemHeight();
            }
        }
    }

    private static interface Reference {
        default public int getIndent() {
            return 0;
        }

        public ITextComponent getText();

        public float getScale();

        public void go();
    }

    private static class CategoryTextEntry
    extends AbstractConfigListEntry<Object> {
        private final ITextComponent category;
        private final ITextComponent text;

        public CategoryTextEntry(ITextComponent category, ITextComponent text) {
            super((ITextComponent)new StringTextComponent(UUID.randomUUID().toString()), false);
            this.category = category;
            this.text = text;
        }

        @Override
        public int getItemHeight() {
            List strings = Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)this.text, this.getParent().getItemWidth());
            if (strings.isEmpty()) {
                return 0;
            }
            return 4 + strings.size() * 10;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        @Override
        public void save() {
        }

        @Override
        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            int yy = y + 2;
            List texts = Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)this.text, this.getParent().getItemWidth());
            for (IReorderingProcessor text : texts) {
                Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, text, (float)(x - 4 + entryWidth / 2 - Minecraft.func_71410_x().field_71466_p.func_243245_a(text) / 2), (float)yy, -1);
                yy += 10;
            }
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }

    private static class EmptyEntry
    extends AbstractConfigListEntry<Object> {
        private final int height;

        public EmptyEntry(int height) {
            super((ITextComponent)new StringTextComponent(UUID.randomUUID().toString()), false);
            this.height = height;
        }

        @Override
        public int getItemHeight() {
            return this.height;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        @Override
        public void save() {
        }

        @Override
        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }
}

